<?

  //PHP-Chat 
  //Copyright (C) 1998-2002 Bernd Gutmann 
  // 
  //This program is free software; you can redistribute it and/or 
  //modify it under the terms of the GNU General Public License 
  //as published by the Free Software Foundation; either version 2 
  //of the License, or (at your option) any later version. 
  // 
  //This program is distributed in the hope that it will be useful, 
  //but WITHOUT ANY WARRANTY; without even the implied warranty of 
  //MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the 
  //GNU General Public License for more details. 
  //
  //You should have received a copy of the GNU General Public License 
  //along with this program; if not, write to the Free Software 
  //Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. 
  // 
  //Bernd Gutmann - post@berndgutmann.de
  //Vincenz Dreger - inside1@gmx.de


  //die Konstanten, die benoetigt werden

  $chatversion = "v1.12";
  $chatdatum   = "2004.04.24";

  include "chat.cfg";

  $hfile       = "history.txt";
  $lfile       = "history.log";

  $tempframe   = "template_frameset.htm";
  $tempinput   = "template_eingabeframe.htm";
  $templine    = "template_line.htm";
  $temptext    = "template_textframe.htm";

  Global $hfile, $lfile, $tempframe, $tempinput, $templine, $temptext, $chatversion, $titel, $hcode, $hcodes;



  //wurde eine Eingabe gemacht?
  if ($eingabe) {
    $eingabe = stripslashes($eingabe);
    $user = stripslashes($user);
    //ja, und es soll $hfile geloescht werden
    if ($eingabe == "#clean") {unlink($hfile);}
    //ja, normaler Eintrag
    else {eintragen($eingabe, $user, $offset, $max_zeilen);}
  }  
  
  //pruefe, was ausgegeben werden soll      
  if ($action == "eingabeframe")
    {$ausgabe = eingabeframe($user);}
  elseif ($action == "textframe")
    {$ausgabe = textframe();}
  else
    {$ausgabe = frameset($user, $user, $tempframe);}

  
  //Ausgabe ausgeben, wir sind fertig
  echo $ausgabe;
  
  
  //#############################################################
  //# ab hier kommen die ganzen Funktionen,                     #
  //# die ich so brauche                                        #
  //#############################################################
  
    
  //#############################################################
  //diese Funktion haengt die $eingabe an history.txt an  
  //#############################################################    
  function eintragen($eingabe, $user, $offset, $max_zeilen)  {

    Global $hfile, $lfile, $tempframe, $tempinput, $templine, $temptext, $chatversion;

    // *** Datum und Zeit getrennt.
    // *** IP-Variable eingefhrt.

    $ip = getenv("REMOTE_ADDR"); 
    $date = getdate(time());
    $date[hours] += $offset;
    if ($date[hours]>23) {
      $date[hours] %= 24;
      $date[mday]++;
    }
    if ($date[hours]<0) {
      $date[hours] %= 24;
      $date[mday]--;
    }    
    
    $datum = trim_inttostr($date[mday],2) . "." .
             trim_inttostr($date[mon],2) . "." .
             trim_inttostr($date[year],2);    
    $zeit  = trim_inttostr($date[hours],2) . ":" .
             trim_inttostr($date[minutes],2) . ":" .
             trim_inttostr($date[seconds],2);
            
    
    $temp = "$user\n$ip\n$datum\n$zeit\n$eingabe";
    
    $counter = 0;

    
    $array = explode(".",$ip); 
    //for($xx=0;$xx<count($array);$xx++){ 
      //$ipx = ($ipx xor $array[$xx]);
      //$ipa = $array[$xx];
      //$ipx = ($ipx && $ipa);
      //$ipx = ((int)$ipx) ^ ((int($array[$xx]);
    //}
    foreach ($array as $part) {
      $part = (int) $part;
      $ipx = $ipx ^ $part;
    }

    $ipx = dechex($ipx);
    $ipx = str_pad($ipx, 2, "0", STR_PAD_LEFT);

    If ($user == "") {
      $user = "Anonym.".$ipx;
    }

            
    if (file_exists($hfile)) {
    	$fhist = fopen($hfile, "r");
    	
    	while (!feof($fhist)) {
        // *** Datum und IP eingefgt
    	  $feld[$counter][user] = str_replace("\n","",fgets($fhist,255));
    	  $feld[$counter][ip] = str_replace("\n","",fgets($fhist,255));
    	  $feld[$counter][datum] = str_replace("\n","",fgets($fhist,255));
    	  $feld[$counter][zeit] = str_replace("\n","",fgets($fhist,255));
    	  $feld[$counter][eintrag] = str_replace("\n","",fgets($fhist,255));
    	  
    	  $counter++;    		
        }
        
        fclose($fhist);
        unlink($hfile);     
    }
    
    //wurde der Eintrag schon mal gesendet??
    $reload=false;
    for ($i=$counter-1; $i>=0; $i--) {
    	//kein Reload, Benutzter hat zwischenzeitlich schon was anderes getippt
    	if ($feld[$i][user]==$user && $feld[$i][eintrag] != $eingabe) break;
    	//reload, also Eintrag nicht noch einmal machen
    	if ($feld[$i][user]==$user && $feld[$i][eintrag] == $eingabe) $reload=true;
    }
    
    if ($reload==false) { 	    
      // *** Datum und IP eingefgt
      $feld[$counter][user]=$user;
      $feld[$counter][ip]=$ip;
      $feld[$counter][datum]=$datum;
      $feld[$counter][zeit]=$zeit;
      $feld[$counter][eintrag]=$eingabe;
      $counter++;
      $start = max(0,$counter-$max_zeilen);
    }  else $start = 0;
    
    $fhlog = fopen($lfile,"a");
      $ausgabex = str_pad($user, 16, " ")."  ".str_pad($ip, 15, "  ", STR_PAD_LEFT)."  ".str_pad($datum, 10, " ")." ".str_pad($zeit, 8, " ")."  ".$eingabe.chr(13).chr(10);
      fputs($fhlog,$ausgabex);
    fclose($fhlog);

    $fhist = fopen($hfile,"w");
    
    for ($i = $start; $i<$counter; $i++) {
      // *** Datum und IP eingefgt
    	$ausgabe = $feld[$i][user]."\n".$feld[$i][ip]."\n".$feld[$i][datum]."\n".$feld[$i][zeit]."\n".$feld[$i][eintrag];
    	$ausgabe = ($i==$counter-1) ? $ausgabe : "$ausgabe\n";
    	fputs($fhist,$ausgabe);
    }
    
    fclose($fhist);            
  }  
  
  //#############################################################
  //diese Funktion wandelt $n in einen String um, der mit
  //Nullen aufgefuellt wird, bis er $len lang ist
  //#############################################################
  function trim_inttostr($n, $len) {    
    for ($temp = "$n"; strlen($temp)<$len; $temp = "0$temp");    
    return $temp;
  }
  
  //#############################################################
  //diese Funktion holt sich die letzten $max_zeilen
  //Eintraege aus history.txt und erzeugt entsprechend der
  //Vorlage "template_line.htm" die Ausgabe
  //#############################################################
  function erzeuge_textblock() {

    Global $hfile, $lfile, $tempframe, $tempinput, $templine, $temptext, $hcode;

    if (!file_exists($templine))
      {die("Die Datei $templine ist nicht vorhanden. (1)");}
      
    //lese die Datei template_line.htm komplett ein
    $f_tmpl = fopen($templine,"r");
    while(!feof($f_tmpl)) $template .= fgets($f_tmpl,255);
    fclose($f_tmpl);
    
    //lese nun history.txt aus, und
    //erzeuge fuer jeden Eintrag Ausgabe
    if (file_exists($hfile)) {
    	$hist = fopen($hfile,"r");
    	$counter = 0;
    	
    	while(!feof($hist)) {    	      		
    	  //Sonderzeichen durch HTML-Codes ersetzen
        // *** Datum und IP eingefgt
        $user  = htmlentities(fgets($hist, 255));
    	  $ip    = htmlentities(fgets($hist, 255));
    	  $datum = htmlentities(fgets($hist, 255));
    	  $zeit  = htmlentities(fgets($hist, 255));
    	  $eingabe = htmlentities(fgets($hist, 255));
    	  
    	  //Smileys durch Bild-Links ersetzen
    	  $eingabe = str_replace(":-)", "<img src=\"smiley.gif\">", $eingabe);
    	  $eingabe = str_replace(":-(", "<img src=\"smiley_sad.gif\">", $eingabe);
    	  $eingabe = str_replace(";-)", "<img src=\"smiley_wink.gif\">", $eingabe);
    	  $eingabe = str_replace(":-D", "<img src=\"smiley_biggrin.gif\">", $eingabe);
    	  $eingabe = str_replace(":-O", "<img src=\"smiley_gaehn.gif\">", $eingabe);
    	  $eingabe = str_replace(":-X", "<img src=\"smiley_death.gif\">", $eingabe);
    	  $eingabe = str_replace(":-/", "<img src=\"smiley_ohwell.gif\">", $eingabe);
    	  $eingabe = str_replace(":-|", "<img src=\"smiley_indiff.gif\">", $eingabe);
    	  $eingabe = str_replace("8-)", "<img src=\"smiley_eek.gif\">", $eingabe);
    	  $eingabe = str_replace("B-)", "<img src=\"smiley_glasses.gif\">", $eingabe);
    	  $eingabe = str_replace(":-P", "<img src=\"smiley_aetsch.gif\">", $eingabe);
    	  $eingabe = str_replace(":-?", "<img src=\"smiley_confused.gif\">", $eingabe);
    	  $eingabe = str_replace(";-(", "<img src=\"smiley_crying.gif\">", $eingabe);
    	  $eingabe = str_replace("):(", "<img src=\"smiley_mad.gif\">", $eingabe);
   	  $eingabe = str_replace("|:(", "<img src=\"smiley_wall.gif\">", $eingabe);
    	  $eingabe = str_replace("O:)", "<img src=\"smiley_holy.gif\">", $eingabe);
    	  $eingabe = str_replace("lol", "<img src=\"smiley_lol.gif\">", $eingabe);
    	  $eingabe = str_replace(":))", "<img src=\"smiley_lol.gif\">", $eingabe);
    	  $eingabe = str_replace(":#)", "<img src=\"smiley_wirr.gif\">", $eingabe);
    	  $eingabe = str_replace(":):)", "<img src=\"smiley_warp.gif\">", $eingabe);
    	  $eingabe = str_replace("(doom)", "<img src=\"smiley_doom.gif\">", $eingabe);

    	  $eingabe = str_replace(":-R", "<img src=\"smiley_respect.gif\">", $eingabe);
    	  $eingabe = str_replace("(@1)", "<img src=\"smiley_cat1.gif\">", $eingabe);
    	  $eingabe = str_replace("(@2)", "<img src=\"smiley_cat2.gif\">", $eingabe);
    	  $eingabe = str_replace("(@3)", "<img src=\"smiley_cat3.gif\">", $eingabe);
    	  $eingabe = str_replace("(kill)", "<img src=\"smiley_kill.gif\">", $eingabe);
    	  $eingabe = str_replace("(rotfl)", "<img src=\"smiley_rotfl.gif\">", $eingabe);
    	  $eingabe = str_replace("(jump)", "<img src=\"smiley_jump.gif\">", $eingabe);
    	  $eingabe = str_replace("(invasion)", "<img src=\"smiley_invasion.gif\">", $eingabe);

    	  $eingabe = str_replace("(c)", "", $eingabe);
    	  $eingabe = str_replace("(r)", "", $eingabe);
    	  $eingabe = str_replace("1/4", "", $eingabe);
    	  $eingabe = str_replace("1/2", "", $eingabe);
    	  $eingabe = str_replace("3/4", "", $eingabe);
    	  $eingabe = str_replace("((", "", $eingabe);
    	  $eingabe = str_replace("))", "", $eingabe);

        // *** '' wird durch "
        // *** { wird durch < und 
        // *** } wird durch > erstezten. Daruch HTML-Code
        //     im Format {img src="smiley.gif"} mglich :)

        if ($hcode == 1) {
    	  $eingabe = str_replace("&lt;", "<", $eingabe);
    	  $eingabe = str_replace("&gt;", ">", $eingabe);
    	  $eingabe = str_replace("&quot;", "\"", $eingabe);
    	  $eingabe = str_replace("&amp;", "&", $eingabe);
        } else {    
    	  $eingabe = str_replace("{", "<", $eingabe);
    	  $eingabe = str_replace("}", ">", $eingabe);
    	  $eingabe = str_replace("''", "\"", $eingabe);
        }
    	  
    	  //die Platzhalter in der Vorlage ausfuellen

        // *** ENTER am ende der Vairablen entfernen, da es zu
        // *** Zeilenumbruch fhrt, wo es nich sollte...
      
        $user = str_replace("\n", "", $user);
        $ip = str_replace("\n", "", $ip);
        $datum = str_replace("\n", "", $datum);
        $zeit = str_replace("\n", "", $zeit);

        // *** Datum und IP eingefgt

    	  $zeile = str_replace("###USER###", $user, $template);
    	  $zeile = str_replace("###IP###", $ip, $zeile);
    	  $zeile = str_replace("###DATUM###", $datum, $zeile);
    	  $zeile = str_replace("###ZEIT###", $zeit, $zeile);
    	  $zeile = str_replace("###EINGABE###", $eingabe, $zeile);
    	  //$zeile = str_replace("\n", "", $zeile);
    	  
    	  $result .= $zeile;
        }
    }
    
        
    return $result;    
  }

  //#############################################################
  //diese Funktion erzeugt den Textframe ensprechend der
  //Vorlage "template_textframe.htm"
  //#############################################################
  function textframe() {

    Global $hfile, $lfile, $tempframe, $tempinput, $templine, $temptext, $refreshs, $user;

    if (!file_exists($temptext))
      {die("Die Datei $temptext ist nicht vorhanden. (2)");}
      
     //lese die Datei template_textframe.htm komplett ein
    $f_tmpl = fopen($temptext,"r");
    while(!feof($f_tmpl)) {$template .= fgets($f_tmpl,255);}
    fclose($f_tmpl);
    
    //ersetze den Platzhalter fuer den Textblock
    $template = str_replace("###REFRESH###", $refreshs, $template);

    //ersetze den Platzhalter fuer den Textblock
    $template = str_replace("###TEXTBLOCK###", erzeuge_textblock($max_zeilen), $template);
    
    return $template;  

  }

  //#############################################################
  //diese Funktion erzeugt den Eingabeframe ensprechend der
  //Vorlage "template_eingabeframe.htm"
  //#############################################################
  function eingabeframe($user) {

    Global $hfile, $lfile, $tempframe, $tempinput, $templine, $temptext, $chatversion, $hcodes;

    if (!file_exists($tempinput))
      {die("Die Datei $tempinput ist nicht vorhanden. (3)");}
      
     //lese die Datei template_eingabeframe.htm komplett ein
    $f_tmpl = fopen($tempinput,"r");
    while(!feof($f_tmpl)) $template .= fgets($f_tmpl,255);
    fclose($f_tmpl);
    
    //ersetze den Platzhalter fuer den Usernamen
    $template = str_replace("###USER###", htmlentities($user), $template);
    //ersetze den Platzhalter fuer die URL
    $template = str_replace("###URL###", "chat.php", $template);
    //ersetze den Platzhalter fuer die Version
    $template = str_replace("###VER###", htmlentities($chatversion), $template);
    //ersetze den Platzhalter fuer HCODE
    $template = str_replace("###HCODE###", htmlentities($hcodes), $template);
    
    return $template;
  }
  
  //#############################################################
  //diese Funktion erzeugt den Frameset ensprechend der
  //Vorlage "template_frameset.htm"
  //#############################################################
  function frameset($user, $user) {

    Global $hfile, $lfile, $tempframe, $tempinput, $templine, $temptext, $titel;

    if (!file_exists($tempframe))
      {die("Die Datei $tempframe ist nicht vorhanden. (4)");}
      
     //lese die Datei template_frameseit.htm komplett ein
    $f_tmpl = fopen($tempframe,"r");
    while(!feof($f_tmpl)) {$template .= fgets($f_tmpl,255);}
    fclose($f_tmpl);

    //ersetze den Platzhalter fuer den Seiten-Titel
    $template = str_replace("###TITEL###", $titel, $template);
    //ersetze den Platzhalter fuer den Textframeurl
    $template = str_replace("###TEXTFRAMEURL###", "chat.php?action=textframe&user=$user", $template);
    //ersetze den Platzhalter fuer die URL
    $template = str_replace("###EINGABEFRAMEURL###", "chat.php?action=eingabeframe&user=$user", $template);
    
    return $template;
  }
 
?>
